import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

const products = [
  { name: 'Paracetamol 500mg', sku: 'MED-001', barcode: '750100000001', supplier: 'Laboratorios Salud', currentStock: 45, minStock: 20, purchaseMultiple: 10 },
  { name: 'Ibuprofeno 400mg', sku: 'MED-002', barcode: '750100000002', supplier: 'Laboratorios Salud', currentStock: 30, minStock: 15, purchaseMultiple: 10 },
  { name: 'Omeprazol 20mg', sku: 'MED-003', barcode: '750100000003', supplier: 'Farmex', currentStock: 18, minStock: 12, purchaseMultiple: 12 },
  { name: 'Loratadina 10mg', sku: 'MED-004', barcode: '750100000004', supplier: 'Farmex', currentStock: 20, minStock: 10, purchaseMultiple: 10 },
  { name: 'Amoxicilina 500mg', sku: 'MED-005', barcode: '750100000005', supplier: 'BioFarma', currentStock: 12, minStock: 10, purchaseMultiple: 6 },
  { name: 'Vitamina C 1g', sku: 'SUP-001', barcode: '750100000006', supplier: 'NutriVida', currentStock: 25, minStock: 12, purchaseMultiple: 12 },
  { name: 'Suero Oral 500ml', sku: 'SUP-002', barcode: '750100000007', supplier: 'HidraPlus', currentStock: 14, minStock: 16, purchaseMultiple: 24 },
  { name: 'Alcohol 70% 250ml', sku: 'HIG-001', barcode: '750100000008', supplier: 'Higienix', currentStock: 22, minStock: 10, purchaseMultiple: 12 },
  { name: 'Gasas Estériles (paq)', sku: 'HIG-002', barcode: '750100000009', supplier: 'Higienix', currentStock: 17, minStock: 20, purchaseMultiple: 20 },
  { name: 'Jeringa 5ml', sku: 'INS-001', barcode: '750100000010', supplier: 'MediTools', currentStock: 120, minStock: 80, purchaseMultiple: 50 },
  { name: 'Termómetro Digital', sku: 'INS-002', barcode: '750100000011', supplier: 'MediTools', currentStock: 9, minStock: 8, purchaseMultiple: 5 },
  { name: 'Cubrebocas KN95 (paq 10)', sku: 'HIG-003', barcode: '750100000012', supplier: 'ProtecCare', currentStock: 11, minStock: 10, purchaseMultiple: 10 },
  { name: 'Aspirina 100mg', sku: 'MED-006', barcode: '750100000013', supplier: 'Laboratorios Salud', currentStock: 28, minStock: 14, purchaseMultiple: 14 },
  { name: 'Diclofenaco Gel 60g', sku: 'MED-007', barcode: '750100000014', supplier: 'BioFarma', currentStock: 8, minStock: 10, purchaseMultiple: 8 },
  { name: 'Sales de Rehidratación', sku: 'SUP-003', barcode: '750100000015', supplier: 'HidraPlus', currentStock: 6, minStock: 12, purchaseMultiple: 12 }
];

async function main() {
  for (const item of products) {
    await prisma.product.upsert({
      where: { sku: item.sku },
      update: item,
      create: item
    });
  }
  console.log(`Seed listo: ${products.length} productos.`);
}

main()
  .catch((error) => {
    console.error(error);
    process.exit(1);
  })
  .finally(async () => {
    await prisma.$disconnect();
  });
