import { Product } from '@prisma/client';

export function calculateSuggestedOrder(product: Pick<Product, 'currentStock' | 'minStock' | 'purchaseMultiple'>) {
  const raw = Math.max(0, product.minStock * 2 - product.currentStock);
  if (raw === 0) {
    return 0;
  }

  const multiple = Math.max(1, product.purchaseMultiple || 1);
  return Math.ceil(raw / multiple) * multiple;
}

export function sanitizeCsvCell(value: string) {
  if (!value) {
    return '';
  }
  const trimmed = value.trim();
  if (/^[=+\-@]/.test(trimmed)) {
    return `'${trimmed}`;
  }
  return trimmed;
}
