type RateEntry = {
  count: number;
  resetAt: number;
};

const attempts = new Map<string, RateEntry>();

export function checkRateLimit(key: string, maxAttempts = 5, windowMs = 15 * 60 * 1000) {
  const now = Date.now();
  const current = attempts.get(key);

  if (!current || current.resetAt <= now) {
    attempts.set(key, { count: 1, resetAt: now + windowMs });
    return { allowed: true, remaining: maxAttempts - 1, retryAfter: 0 };
  }

  if (current.count >= maxAttempts) {
    return {
      allowed: false,
      remaining: 0,
      retryAfter: Math.ceil((current.resetAt - now) / 1000)
    };
  }

  current.count += 1;
  attempts.set(key, current);
  return {
    allowed: true,
    remaining: Math.max(0, maxAttempts - current.count),
    retryAfter: 0
  };
}
