'use client';

import { useEffect, useState } from 'react';
import { useToast } from '@/components/toast';

export function SheetsSettings() {
  const { showToast } = useToast();
  const [url, setUrl] = useState('');
  const [gid, setGid] = useState('');

  useEffect(() => {
    setUrl(localStorage.getItem('inventario:sheets:url') || '');
    setGid(localStorage.getItem('inventario:sheets:gid') || '');
  }, []);

  function save() {
    localStorage.setItem('inventario:sheets:url', url.trim());
    localStorage.setItem('inventario:sheets:gid', gid.trim());
    showToast('Configuración guardada en este dispositivo', 'success');
  }

  return (
    <div className="mx-auto max-w-3xl px-4 pb-24 pt-4">
      <h1 className="text-2xl font-bold text-slate-900">Configuración Google Sheets</h1>
      <p className="mt-2 text-sm text-slate-600">
        1) En Google Sheets abre Archivo {'>'} Compartir {'>'} Publicar en la web.
      </p>
      <p className="text-sm text-slate-600">2) Elige la hoja y formato CSV.</p>
      <p className="text-sm text-slate-600">3) Copia la URL aquí para usarla rápido en la pantalla de Importar.</p>

      <div className="mt-4 rounded-2xl border border-slate-200 bg-white p-4">
        <label className="text-sm font-semibold text-slate-700">URL de Google Sheets (CSV o normal)</label>
        <input
          value={url}
          onChange={(event) => setUrl(event.target.value)}
          className="mt-1 w-full rounded-xl border border-slate-300 px-3 py-3"
          placeholder="https://docs.google.com/spreadsheets/..."
        />

        <label className="mt-3 block text-sm font-semibold text-slate-700">GID opcional</label>
        <input
          value={gid}
          onChange={(event) => setGid(event.target.value)}
          className="mt-1 w-full rounded-xl border border-slate-300 px-3 py-3"
          placeholder="0"
        />

        <button onClick={save} className="mt-4 w-full rounded-xl bg-brand-600 px-4 py-3 font-semibold text-white">
          Guardar configuración
        </button>
      </div>
    </div>
  );
}
