'use client';

import Link from 'next/link';
import { usePathname } from 'next/navigation';

const links = [
  { href: '/venta-rapida', label: 'Venta' },
  { href: '/ingreso-inventario', label: 'Ingreso' },
  { href: '/reabastecimiento', label: 'Reabastecer' },
  { href: '/productos', label: 'Productos' },
  { href: '/importar', label: 'Importar' }
];

export function MobileNav() {
  const pathname = usePathname();

  return (
    <nav className="fixed bottom-0 left-0 right-0 z-40 border-t border-slate-200 bg-white/95 backdrop-blur">
      <ul className="mx-auto grid max-w-3xl grid-cols-5">
        {links.map((item) => {
          const active = pathname === item.href;
          return (
            <li key={item.href}>
              <Link
                href={item.href}
                className={`flex min-h-16 items-center justify-center px-2 text-center text-xs font-semibold ${
                  active ? 'text-brand-700' : 'text-slate-500'
                }`}
              >
                {item.label}
              </Link>
            </li>
          );
        })}
      </ul>
    </nav>
  );
}
