'use client';

import { useRouter } from 'next/navigation';
import { useToast } from '@/components/toast';

export function LogoutButton() {
  const router = useRouter();
  const { showToast } = useToast();

  async function logout() {
    try {
      await fetch('/api/auth/logout', { method: 'POST' });
      showToast('Sesión cerrada', 'success');
      router.replace('/login');
      router.refresh();
    } catch {
      showToast('No se pudo cerrar sesión', 'error');
    }
  }

  return (
    <button onClick={logout} className="rounded-lg border border-slate-300 px-2 py-1 text-xs font-semibold text-slate-700">
      Salir
    </button>
  );
}
