import type { Metadata } from 'next';
import './globals.css';
import { ToastProvider } from '@/components/toast';
import { PwaRegister } from '@/components/pwa-register';

export const metadata: Metadata = {
  title: 'Inventario Farmacia',
  description: 'Control de inventario, ventas y reabastecimiento para farmacia',
  manifest: '/manifest.webmanifest'
};

export default function RootLayout({ children }: { children: React.ReactNode }) {
  return (
    <html lang="es">
      <body>
        <ToastProvider>
          <PwaRegister />
          {children}
        </ToastProvider>
      </body>
    </html>
  );
}
