import { NextRequest, NextResponse } from 'next/server';
import { requireApiAuth } from '@/lib/auth';
import { prisma } from '@/lib/prisma';
import { calculateSuggestedOrder } from '@/lib/restock';

export async function GET(request: NextRequest) {
  const authError = await requireApiAuth(request);
  if (authError) return authError;

  const supplier = request.nextUrl.searchParams.get('supplier')?.trim();

  const products = await prisma.product.findMany({
    where: {
      isActive: true,
      ...(supplier ? { supplier } : {})
    },
    orderBy: [{ supplier: 'asc' }, { name: 'asc' }]
  });

  const result = products
    .filter((product) => product.currentStock <= product.minStock)
    .map((product) => ({
      ...product,
      suggestedOrder: calculateSuggestedOrder(product)
    }));

  return NextResponse.json(result);
}
