import Link from 'next/link';
import { MobileNav } from '@/components/mobile-nav';
import { LogoutButton } from '@/components/logout-button';

export default function AppLayout({ children }: { children: React.ReactNode }) {
  return (
    <div className="min-h-screen">
      <header className="sticky top-0 z-30 border-b border-slate-200 bg-white/95 backdrop-blur">
        <div className="mx-auto flex max-w-3xl items-center justify-between px-4 py-3">
          <Link href="/venta-rapida" className="text-base font-bold text-brand-700">
            Inventario Farmacia
          </Link>
          <div className="flex items-center gap-3">
            <Link href="/configuracion" className="text-sm font-medium text-slate-600">
              Configuración
            </Link>
            <LogoutButton />
          </div>
        </div>
      </header>
      <main>{children}</main>
      <MobileNav />
    </div>
  );
}
