# Inventario Farmacia

Aplicación web mobile-first para farmacia: controla productos, venta rápida, ingreso de inventario, lista de reabastecimiento, importación por archivo y sincronización desde Google Sheets (sin OAuth).

## Stack

- Next.js 14 (App Router) + TypeScript
- Tailwind CSS
- Prisma + SQLite
- API con Route Handlers
- Auth simple por contraseña de admin + cookie httpOnly firmada
- PWA (instalable + caché offline de lectura en productos/reabastecimiento)

## Requisitos

- Node.js 18+
- npm

## Ejecutar local

1. Instalar dependencias:

```bash
npm install
```

2. Crear `.env` basado en `.env.example`:

```bash
cp .env.example .env
```

3. Ejecutar migraciones:

```bash
npx prisma migrate dev
```

4. Poblar datos demo (15 productos):

```bash
npm run seed
```

5. Levantar entorno desarrollo:

```bash
npm run dev
```

App en: [http://localhost:3000](http://localhost:3000)

## Despliegue en cPanel (adaptado a FTP + Node.js)

> Importante: esta app tiene backend (API, Prisma, auth), así que **no funciona como sitio estático** subido por FTP solamente.

### 1) Subir archivos

- Sube todo el proyecto por FTP/SFTP o Administrador de Archivos de cPanel.
- Ejemplo de ruta: `/home/USUARIO/apps/inventario-farmacia`

### 2) Crear Node.js App en cPanel

En **Setup Node.js App**:

- Node.js: 18+ (ideal 20)
- Application root: carpeta del proyecto
- Startup file: `app.js`

### 3) Variables de entorno para cPanel

Crea `.env` en el servidor (o usa el panel de variables de cPanel) con base en `.env.cpanel.example`:

```env
ADMIN_PASSWORD="tu_password_admin"
SESSION_SECRET="una_clave_larga_y_segura"
DATABASE_URL="file:./prisma/prod.db"
```

### 4) Instalar/build/migrar en terminal de cPanel

```bash
npm install
npm run build:cpanel
npx prisma migrate deploy
```

### 5) Reiniciar la app

Desde cPanel, pulsa **Restart** en la Node.js App.

### 6) Verificación

- URL principal: carga `/login`
- Healthcheck: `/api/health`

Guía corta adicional en: `deploy/cpanel/README.md`.

## Variables de entorno

```env
DATABASE_URL="file:./dev.db"
ADMIN_PASSWORD="tu_password_admin"
SESSION_SECRET="una_clave_larga_y_segura"
```

## Flujo principal

- `/login`: acceso admin
- `/venta-rapida`: descontar stock por venta
- `/ingreso-inventario`: agregar stock rápido
- `/reabastecimiento`: lista con sugerido + export CSV + imprimir
- `/productos`: alta/edición/baja lógica
- `/importar`: carga archivo + sync Google Sheets
- `/configuracion`: guardar URL/GID de Sheets en el dispositivo

## Lógica de sugerido para reabastecimiento

```txt
suggested = max(0, (2 * min_stock) - current_stock)
si purchaseMultiple > 1 => redondear hacia arriba al múltiplo
```

## Importación de productos (Excel/CSV)

Headers compatibles (inglés o español):

- `name` / `nombre`
- `sku` / `codigo`
- `barcode` / `codigo_barras`
- `supplier` / `proveedor`
- `currentStock` / `stock` / `stock_actual`
- `minStock` / `minimo` / `stock_minimo`
- `purchaseMultiple` / `multiplo_compra`

### Modos de importación

1. `MERGE`: actualiza campos enviados y conserva el resto
2. `REPLACE_STOCK`: si llega stock, reemplaza el stock actual
3. `ADD_STOCK`: si llega stock, suma al stock actual

### Reglas de UPSERT

Orden de búsqueda para actualizar: `sku` -> `barcode` -> `name`.

## Plantilla CSV/Excel

Puedes copiar esta fila de encabezados para preparar tu archivo:

```csv
nombre,sku,codigo_barras,proveedor,stock_actual,stock_minimo,multiplo_compra
```

Ejemplo mínimo:

```csv
Paracetamol 500mg,MED-001,750100000001,Laboratorios Salud,45,20,10
```

También tienes plantilla en: `templates/plantilla_importacion.csv`.

## Google Sheets sin OAuth

### Opción A (recomendada): URL publicada a CSV

1. En Google Sheets: **Archivo > Compartir > Publicar en la web**
2. Elige hoja + formato **CSV**
3. Copia la URL publicada y pégala en `/importar`

### Opción B: URL normal + GID

- Pega la URL normal de la hoja y el `gid` (opcional si ya viene en la URL).
- El backend intentará construir una URL CSV.
- Si falla por permisos, publica la hoja en web como CSV (Opción A).

## Instalación alternativa en VPS (Docker + dominio)

Esta opción deja la app pública para pruebas usando Docker + Caddy (HTTPS automático).

### 1) Requisitos del servidor

- VPS Linux con Docker y Docker Compose
- Dominio apuntando al VPS con registro A/AAAA
- Puertos `80` y `443` abiertos

### 2) Preparar variables de despliegue

```bash
cp .env.web.example .env.web
```

Edita `.env.web` con:

- `DOMAIN` (ej. `inventario.midominio.com`)
- `LETSENCRYPT_EMAIL`
- `ADMIN_PASSWORD`
- `SESSION_SECRET` (clave larga)

### 3) Publicar en la web

```bash
./scripts/deploy-web.sh
```

o manualmente:

```bash
docker compose --env-file .env.web up --build -d
```

### 4) Verificar estado

```bash
docker compose ps
docker compose logs -f app
docker compose logs -f caddy
```

### 5) URL pública

- App: `https://TU_DOMINIO`
- Salud: `https://TU_DOMINIO/api/health`

SQLite persiste en volumen Docker `inventario_data`.

## Estructura de despliegue web

- `docker-compose.yml`: app + reverse proxy Caddy + volúmenes persistentes
- `deploy/Caddyfile`: configuración de dominio y HTTPS automático
- `.env.web.example`: plantilla de variables para entorno web
- `scripts/deploy-web.sh`: comando rápido de despliegue

## Seguridad implementada

- Password de admin desde `ADMIN_PASSWORD`
- Cookie de sesión firmada (`SESSION_SECRET`), `httpOnly`, `sameSite=strict`, `secure` en producción
- Rate limit básico en login (memoria)
- Validación con Zod en cliente y servidor
- Sanitización básica de importación

## Notas PWA

- Manifest + service worker incluidos
- Cachea lecturas GET de `/api/products` y `/api/restock`
- Modo offline: consulta de listas si hubo caché previa
- Acciones de escritura requieren conexión
